/////////////////////////////////////////////////////////////////////////////////////////
//
// LCD Library for Freescale DEMO9S08GW64
//
/////////////////////////////////////////////////////////////////////////////////////////
#include "lcd.h"
#include "MC9S08GW64.h"
/////////////////////////////////////////////////////////////////////////////////////////
// Variables
/////////////////////////////////////////////////////////////////////////////////////////


const struct lcd_char_segs lcd_char_table[] = {

  // ' ' (Space)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '"' (Quotation Mark)
  {
  LCD_SEG_K,
  LCD_SEG_H
  },

  // ''' (Apostrophe)
  {
  LCD_SEG_NONE,
  LCD_SEG_H
  },

  // '(' (Left Parenthesis)
  {
  LCD_SEG_K | LCD_SEG_L,
  LCD_SEG_NONE
  },

  // ')' (Right Parenthesis)
  {
  LCD_SEG_NONE,
  LCD_SEG_H | LCD_SEG_N
  },

  // '*' (Asterisk)
  {
  LCD_SEG_J | LCD_SEG_K | LCD_SEG_L | LCD_SEG_M, 
  LCD_SEG_H | LCD_SEG_G | LCD_SEG_N
  },

  // '+' (Plus Sign)
  {
  LCD_SEG_J |LCD_SEG_M,
  LCD_SEG_G 
  },

  // ',' (Comma)
  {
  LCD_SEG_NONE,
  LCD_SEG_N
  },

  // '-' (Minus Sign)
  {
  LCD_SEG_NONE,
  LCD_SEG_G
  },

  // '.' (Period)
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '/' (Slash)
  {
  LCD_SEG_K,
  LCD_SEG_N
  },

  // '0'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A  
  },

  // '1'
  {
  LCD_SEG_B | LCD_SEG_C,
  LCD_SEG_NONE
  },

  // '2'
  {
  LCD_SEG_D | LCD_SEG_B,
  LCD_SEG_A | LCD_SEG_G | LCD_SEG_E
  },

  // '3'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_A | LCD_SEG_G
  },

  // '4'
  {
  LCD_SEG_B | LCD_SEG_C,
  LCD_SEG_F | LCD_SEG_G
  },

  // '5'
  {
  LCD_SEG_D | LCD_SEG_C,
  LCD_SEG_F | LCD_SEG_A | LCD_SEG_G
  },

  // '6'
  {
  LCD_SEG_D | LCD_SEG_C,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_G
  },

  // '7'
  {
  LCD_SEG_B | LCD_SEG_C,
  LCD_SEG_A 
  },

  // '8'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_G
  },

  // '9'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_A | LCD_SEG_G | LCD_SEG_F
  },

  // ':'
  {
  LCD_SEG_NONE,
  LCD_SEG_NONE
  },

  // '=' (Equal Sign)
  {
  LCD_SEG_D,
  LCD_SEG_G
  },

  // 'A'
  {
  LCD_SEG_B | LCD_SEG_C,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_G
  },

  // 'B'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_J | LCD_SEG_M | LCD_SEG_D,
  LCD_SEG_A | LCD_SEG_G 
  },

  // 'C'
  {
  LCD_SEG_D,
  LCD_SEG_A | LCD_SEG_E | LCD_SEG_F
  },

  // 'D'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D | LCD_SEG_J | LCD_SEG_M,
  LCD_SEG_A 
  },

  // 'E'
  {
  LCD_SEG_D,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_G
  },

  // 'F'
  {
  LCD_SEG_NONE,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_G
  },

  // 'G'
  {
  LCD_SEG_D | LCD_SEG_L,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A
  },

  // 'H'
  {
  LCD_SEG_B | LCD_SEG_C,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_G
  },

  // 'I'
  {
  LCD_SEG_J | LCD_SEG_D |  LCD_SEG_M,
  LCD_SEG_A 
  },

  // 'J'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_E
  },
  
  // 'K'
  {
  LCD_SEG_J | LCD_SEG_M | LCD_SEG_K | LCD_SEG_L,
  LCD_SEG_NONE
  },

  // 'L'
  {
  LCD_SEG_D,
  LCD_SEG_E | LCD_SEG_F
  },

  // 'M'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_K,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_H
  },

  // 'N'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_L,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_H
  },

  // 'O'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A
  },

  // 'P'
  {
  LCD_SEG_B,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_G
   },

  // 'Q'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D | LCD_SEG_L,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A
  },

  // 'R'
  {
  LCD_SEG_B | LCD_SEG_L,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_A | LCD_SEG_G
  },

  // 'S'
  {
  LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_A | LCD_SEG_G | LCD_SEG_F
   },

  // 'T'
  {
  LCD_SEG_J | LCD_SEG_M,
  LCD_SEG_A  
  },

  // 'U'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_E | LCD_SEG_F
  },

  // 'V'
  {
  LCD_SEG_K,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_N
  },

  // 'W'
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_L,
  LCD_SEG_E | LCD_SEG_F | LCD_SEG_N
  },

  // 'X'
  {
  LCD_SEG_K | LCD_SEG_L,
  LCD_SEG_H | LCD_SEG_N 
  },

  // 'Y'
  {
  LCD_SEG_M | LCD_SEG_K,
  LCD_SEG_H
  },

  // 'Z'
  {
  LCD_SEG_D | LCD_SEG_K,
  LCD_SEG_N | LCD_SEG_A
  },

  // '[' (Left Bracket)
  {
  LCD_SEG_D,
  LCD_SEG_F | LCD_SEG_E | LCD_SEG_A
  },

  // '\' (Backslash)
  {
  LCD_SEG_L,
  LCD_SEG_H
  },

  // ']' (Right Bracket)
  {
  LCD_SEG_B | LCD_SEG_C | LCD_SEG_D,
  LCD_SEG_A
  },

  // '^' (Exponent)
  {
  LCD_SEG_K | LCD_SEG_B,
  LCD_SEG_NONE
  },

  // '_' (Underline)
  {
  LCD_SEG_D,
  LCD_SEG_NONE
  },

  // '|' (Vertical Bar)
  {
  LCD_SEG_J | LCD_SEG_M,
  LCD_SEG_NONE
  },

  // Test
  {
  LCD_SEG_J | LCD_SEG_K | LCD_SEG_B | LCD_SEG_C | LCD_SEG_L | LCD_SEG_M | LCD_SEG_D,
  LCD_SEG_A | LCD_SEG_H | LCD_SEG_F | LCD_SEG_G | LCD_SEG_E | LCD_SEG_N
  }
  
};



/*provides a delay*/
void Delay(unsigned int no_of_qseconds)
{
  unsigned int qseconds;
  qseconds = 0;
  while(qseconds < no_of_qseconds * 1000)
  qseconds++;
}


/////////////////////////////////////////////////////////////////////////////////////////
// LCDFindChar
// --------------------------------------------------------------------------------------
// Finds the given character in the characters table
/////////////////////////////////////////////////////////////////////////////////////////
unsigned char LCDFindChar(unsigned char character)
{
  if(character == ' ')
    return(LCD_CHAR_SPACE);
  else if(character == '"')
    return(LCD_CHAR_QUOTMARK);
  else if(character >= '\'' && character <= ':')
    return(character - '\'' + LCD_CHAR_APOSTROPHE);
/*  else if(character == '/')
    return(LCD_CHAR_SLASH);
  else if(character >= '0' && character <= '9')
    return(character - '0' + LCD_CHAR_0);*/
  else if(character == '=')
    return(LCD_CHAR_EQUAL);
  else if(character >= 'A' && character <= '_')
    return(character - 'A' + LCD_CHAR_A);
/*  else if(character == '\\')
    return(LCD_CHAR_BACKSLASH);
  else if(character == '_')
    return(LCD_CHAR_UNDERLINE);*/
  else if(character >= 'a' && character <= 'z')
    return(character - 'a' + LCD_CHAR_A);
  else if(character == '|')
    return(LCD_CHAR_VERTBAR);
  else
    return(LCD_CHAR_TEST);
  
}

/////////////////////////////////////////////////////////////////////////////////////////
// LCDPutChar
// --------------------------------------------------------------------------------------
// Put Char in the LCDRAM Register
/////////////////////////////////////////////////////////////////////////////////////////
void LCDPutChar(unsigned char character, unsigned char digit)
{

  unsigned char *pLCDPIN5 = &LCDPIN5, table_pos, mytempreg;
  unsigned char *pLCDPIN9 = &LCDPIN9;
  unsigned char *pLCDPIN28= &LCDPIN28;

  if(digit > NUM_DIGITS)       //if the digit is greater than the max digits available then error
    return;

  table_pos = LCDFindChar(character);  
  
  if(table_pos == LCD_CHAR_TEST)
  {
    return;
  }
  
  if(character == '.')
  {
    LCDWriteSegment(DTx,digit);
    return;
  }
  if(character == ':')
  {
    LCDWriteSegment(COLx,digit);
    return;
  }
 
  
 
    //Clears Segments J K B C L M D 
    mytempreg = *(pLCDPIN9+(digit-1)) & ~MASK_JKBCLMD;
    mytempreg |= lcd_char_table[table_pos].JKBCLMD;
    //Writes Segments J K B C L M D
    *(pLCDPIN9+(digit-1)) = mytempreg;
    
    //Clears Segments A H F G E N
    mytempreg = *(pLCDPIN28-(digit-1)) & ~MASK_AHFGEN;
    mytempreg |= lcd_char_table[table_pos].AHFGEN;
    //Writes Segments A H F G E N
    *(pLCDPIN28 -(digit-1)) = mytempreg;
  

  
}

/////////////////////////////////////////////////////////////////////////////////////////
// LCDWriteSegment
// --------------------------------------------------------------------------------------
// Enables Segment in the LCDRAM Register
/////////////////////////////////////////////////////////////////////////////////////////
void LCDWriteSegment(enum symbol s, unsigned char num)
{

 
   switch(s)
    {
    
      case TIME:
        LCDPIN9  |= LCD_SEG_SP1;
        break;
      case DATE:
        LCDPIN10 |= LCD_SEG_SP1;
        break;
      case TEMP:
        LCDPIN11 |= LCD_SEG_SP1;
        break;
      case VOLUME:
        LCDPIN12 |= LCD_SEG_SP1;
        break;
      case CONTRAST:
        LCDPIN13 |= LCD_SEG_SP1;
        break;
      case MODE:
        LCDPIN14 |= LCD_SEG_SP1;
        break;
      case PROGRAM:
        LCDPIN15 |= LCD_SEG_SP1;
        break;
      case OM:
        LCDPIN16 |= LCD_SEG_SP1;
        break;
      case AM:
        LCDPIN18 |= LCD_SEG_M3;
        break;
      case PM:
        LCDPIN18 |= LCD_SEG_M2;
        break;
      case KWH:
        LCDPIN18 |= LCD_SEG_M7;
        break;
      case AMPS:
        LCDPIN18 |= LCD_SEG_M1;
        break;
      case VOLTS:
        LCDPIN18 |= LCD_SEG_M8;
        break;
      case VOL:
        LCDPIN19 |= LCD_SEG_M6;
        break;
      case T:
        LCDPIN19 |= LCD_SEG_M3;
        break;
      case P:
        LCDPIN22 |= LCD_SEG_SP3;
        break;    
      case FIRE:
        LCDPIN27 |= LCD_SEG_SP3;
        break;    
      case FREESCALE:
        LCDPIN28 |= LCD_SEG_SP3;
        break;
      case SNOWFLAKE:
        LCDPIN25 |= LCD_SEG_SP3;
        break;
      case ALARM:
        LCDPIN24 |= LCD_SEG_SP3;
        break;
      case DT:
        LCDPIN28 |= LCD_SEG_SP2;
        break;

      case DTx:
        switch(num)
        {
          case 1:
            LCDPIN27 |= LCD_SEG_SP2;
            break;
          case 2:
            LCDPIN26 |= LCD_SEG_SP2;
            break;        
          case 3:
            LCDPIN25 |= LCD_SEG_SP2;
            break;         
          case 4:
            LCDPIN24 |= LCD_SEG_SP2;
            break;        
          case 5:
            LCDPIN23 |= LCD_SEG_SP2;
            break;        
          case 6:
            LCDPIN22 |= LCD_SEG_SP2;
            break;        
          case 7:
            LCDPIN21 |= LCD_SEG_SP2;
            break;        
          case 8:
            LCDPIN20 |= LCD_SEG_SP2;
            break;        
          case 9:
            LCDPIN17 |= LCD_SEG_SP1;
            break;        
        }
        break;
      case COLx:
        switch(num)
        {
          case 2:
            LCDPIN26 |= LCD_SEG_SP3;
            break;
          case 5:
            LCDPIN23 |= LCD_SEG_SP3;
            break;        
          case 7:
            LCDPIN21 |= LCD_SEG_SP3;
            break;         
          case 8: //Degrees
            LCDPIN20 |= LCD_SEG_SP3;
            break;               
        }
        break;
      case Vx:
        switch(num)
        {
          case 1:
            LCDPIN19 |= LCD_SEG_M4;
            break;
          case 2:
            LCDPIN19 |= LCD_SEG_M5;
            break;        
          case 3:
            LCDPIN18 |= LCD_SEG_M5;
            break;         
          case 4:
            LCDPIN18 |= LCD_SEG_M4;
            break;
          case 5:
            LCDPIN18 |= LCD_SEG_M6;
            break;                          
        }
        break;
      case Tx:
        switch(num)
        {
          case 1:
            LCDPIN19 |= LCD_SEG_M8;
            break;
          case 2:
            LCDPIN19 |= LCD_SEG_M1;
            break;        
          case 3:
            LCDPIN19 |= LCD_SEG_M2;
            break;         
          case 4:
            LCDPIN19 |= LCD_SEG_M7;
            break;                        
        }
        break;
       case Mx:
        switch(num)
        {
          case 1:
            LCDPIN29 |= LCD_SEG_M1;
            break;
          case 2:
            LCDPIN29 |= LCD_SEG_M2;
            break;        
          case 3:
            LCDPIN29 |= LCD_SEG_M3;
            break;         
          case 4:
            LCDPIN29 |= LCD_SEG_M4;
            break;
          case 5:
            LCDPIN29 |= LCD_SEG_M5;
            break;
          case 6:
            LCDPIN29 |= LCD_SEG_M6;
            break;
          case 7:
            LCDPIN29 |= LCD_SEG_M7;
            break;
          case 8:
            LCDPIN29 |= LCD_SEG_M8;
            break;                                
        }
        break; 
        
    }  
  
}

/////////////////////////////////////////////////////////////////////////////////////////
// LCDClearSegment
// --------------------------------------------------------------------------------------
// Disables Segment in the LCDRAM Register
/////////////////////////////////////////////////////////////////////////////////////////
void LCDClearSegment(enum symbol s, unsigned char num)
{
 

  switch(s)
    {
    
      case TIME:
        LCDPIN9   &= ~LCD_SEG_SP1;
        break;
      case DATE:
        LCDPIN10  &= ~LCD_SEG_SP1;
        break;
      case TEMP:
        LCDPIN11  &= ~LCD_SEG_SP1;
        break;
      case VOLUME:
        LCDPIN12  &= ~LCD_SEG_SP1;
        break;
      case CONTRAST:
        LCDPIN13  &= ~LCD_SEG_SP1;
        break;
      case MODE:
        LCDPIN14  &= ~LCD_SEG_SP1;
        break;
      case PROGRAM:
        LCDPIN15  &= ~LCD_SEG_SP1;
        break;
      case OM:
        LCDPIN16  &= ~LCD_SEG_SP1;
        break;
      case AM:
        LCDPIN18  &= ~LCD_SEG_M3;
        break;
      case PM:
        LCDPIN18  &= ~LCD_SEG_M2;
        break;
      case KWH:
        LCDPIN18  &= ~LCD_SEG_M7;
        break;
      case AMPS:
        LCDPIN18  &= ~LCD_SEG_M1;
        break;
      case VOLTS:
        LCDPIN18  &= ~LCD_SEG_M8;
        break;
      case VOL:
        LCDPIN19  &= ~LCD_SEG_M6;
        break;
      case T:
        LCDPIN19  &= ~LCD_SEG_M3;
        break;
      case P:
        LCDPIN22  &= ~LCD_SEG_SP3;
        break;    
      case FIRE:
        LCDPIN27  &= ~LCD_SEG_SP3;
        break;    
      case FREESCALE:
        LCDPIN28  &= ~LCD_SEG_SP3;
        break;
      case SNOWFLAKE:
        LCDPIN25  &= ~LCD_SEG_SP3;
        break;
      case ALARM:
        LCDPIN24  &= ~LCD_SEG_SP3;
        break;
      
      case DTx:
        switch(num)
        {
          case 1:
            LCDPIN27 &= ~LCD_SEG_SP2;
            break;
          case 2:
            LCDPIN26 &= ~LCD_SEG_SP2;
            break;        
          case 3:
            LCDPIN25 &= ~LCD_SEG_SP2;
            break;         
          case 4:
            LCDPIN24 &= ~LCD_SEG_SP2;
            break;        
          case 5:
            LCDPIN23 &= ~LCD_SEG_SP2;
            break;        
          case 6:
            LCDPIN22 &= ~LCD_SEG_SP2;
            break;        
          case 7:
            LCDPIN21 &= ~LCD_SEG_SP2;
            break;        
          case 8:
            LCDPIN20 &= ~LCD_SEG_SP2;
            break;        
          case 9:
            LCDPIN17 &= ~LCD_SEG_SP1;
            break;        
        }
        break;
      case COLx:
        switch(num)
        {
          case 2:
            LCDPIN26 &= ~LCD_SEG_SP3;
            break;
          case 5:
            LCDPIN23 &= ~LCD_SEG_SP3;
            break;        
          case 7:
            LCDPIN21 &= ~LCD_SEG_SP3;
            break;         
          case 8: //Degrees
            LCDPIN22 &= ~LCD_SEG_SP3;
            break;               
        }
        break;
      case Vx:
        switch(num)
        {
          case 1:
            LCDPIN19 &= ~LCD_SEG_M4;
            break;
          case 2:
            LCDPIN19 &= ~LCD_SEG_M5;
            break;        
          case 3:
            LCDPIN18 &= ~LCD_SEG_M5;
            break;         
          case 4:
            LCDPIN18 &= ~LCD_SEG_M4;
            break;
          case 5:
            LCDPIN18 &= ~LCD_SEG_M6;
            break;                          
        }
        break;
      case Tx:
        switch(num)
        {
          case 1:
            LCDPIN19 &= ~LCD_SEG_M8;
            break;
          case 2:
            LCDPIN19 &= ~LCD_SEG_M1;
            break;        
          case 3:
            LCDPIN19 &= ~LCD_SEG_M2;
            break;         
          case 4:
            LCDPIN19 &= ~LCD_SEG_M7;
            break;                        
        }
        break;
    }  
    
   
  
}



void LCDClearSegs(void)
{
  
  char i;
  
  LCDWriteSegment(TIME,0);
  Delay(1);
  LCDWriteSegment(DT,0);
  Delay(1);
  LCDWriteSegment(DATE,0);
  Delay(1);
  LCDWriteSegment(FREESCALE,0);
  Delay(1);
  LCDWriteSegment(FIRE,0);
  Delay(1);
  LCDWriteSegment(TEMP,0);
  Delay(1);
  LCDWriteSegment(SNOWFLAKE,0);
  Delay(1);
  LCDWriteSegment(VOLUME,0);
  Delay(1);
  LCDWriteSegment(ALARM,0);
  Delay(1);
  LCDWriteSegment(T,0);
  Delay(1);
  LCDWriteSegment(P,0);
  Delay(1);
  LCDWriteSegment(CONTRAST,0);
  Delay(1);
  LCDWriteSegment(MODE,0);
  Delay(1);
  LCDWriteSegment(AM,0);
  Delay(1);
  LCDWriteSegment(PM,0);
  Delay(1);
  LCDWriteSegment(OM,0);
  Delay(1);
  LCDWriteSegment(KWH,0);
  Delay(1);
  LCDWriteSegment(AMPS,0);
  Delay(1);
  LCDWriteSegment(VOLTS,0); 
  Delay(1);
  LCDWriteSegment(PROGRAM,0);
  Delay(1);
  LCDWriteSegment(VOL,0);
  Delay(1);
  for (i=1; i<10; i++) 
  {
    LCDWriteSegment(DTx,i);
    Delay(1);
    if (i<6) 
    {
      LCDWriteSegment(Vx,i);
      Delay(1);
      if (i<5) 
      {
        LCDWriteSegment(COLx,i);
        Delay(1);
        LCDWriteSegment(Tx,i);
        Delay(1);
      }
    }
  }       
}

void LCDClearDigit(unsigned char digit)
{
  unsigned char *pLCDPIN9 = &LCDPIN9;
  unsigned char *pLCDPIN28= &LCDPIN28;
  unsigned char mytempreg;
   
   *(pLCDPIN9+(digit-1)) &= ~MASK_JKBCLMD;
   *(pLCDPIN28-(digit-1)) &= ~MASK_AHFGEN;
   

}
/////////////////////////////////////////////////////////////////////////////////////////
// LCDTest
// --------------------------------------------------------------------------------------
// Enable all segments in the LCDRAM Register
/////////////////////////////////////////////////////////////////////////////////////////
void LCDTest (void)
{
  
  char i;
  
  LCDWriteSegment(TIME,0);
  LCDWriteSegment(DT,0);
  LCDWriteSegment(DATE,0);
  LCDWriteSegment(FREESCALE,0);
  LCDWriteSegment(FIRE,0);
  LCDWriteSegment(TEMP,0);
  LCDWriteSegment(SNOWFLAKE,0);
  LCDWriteSegment(VOLUME,0);
  LCDWriteSegment(ALARM,0);
  LCDWriteSegment(T,0);
  LCDWriteSegment(P,0);
  LCDWriteSegment(CONTRAST,0);
  LCDWriteSegment(MODE,0);
  LCDWriteSegment(AM,0);
  LCDWriteSegment(PM,0);
  LCDWriteSegment(OM,0);
  LCDWriteSegment(KWH,0);
  LCDWriteSegment(AMPS,0);
  LCDWriteSegment(VOLTS,0); 
  LCDWriteSegment(PROGRAM,0);
  LCDWriteSegment(VOL,0);
  LCDWriteSegment(COLx,2);
  LCDWriteSegment(COLx,5);
  LCDWriteSegment(COLx,7);
  LCDWriteSegment(COLx,8);
  
  
  
  for (i=1; i<9; i++)
   LCDWriteSegment(Mx,i);
   
 
   
  for (i=1; i<10; i++) 
  { 
    LCDPutChar('?', i);
    LCDWriteSegment(DTx,i);
    if (i<6) 
    {
      LCDWriteSegment(Vx,i);
      if (i<5) 
      {
        LCDWriteSegment(Tx,i);
      }
    }
  }  
       
}
